#define F_CPU 8000000L

#include <avr/io.h>
#include <util/delay.h>

// set port direction for output
#define output(directions,pin) (directions |= pin)

// set port direction for input
#define input(directions,pin) (directions &= (~pin))

// set port pin
#define set(port,pin) (port |= pin)

// clear port pin
#define clear(port,pin) (port &= (~pin))

// test for port pin
#define pin_test(pins,pin) (pins & pin)

// test for bit set
#define bit_test(byte,bit) (byte & (1 << bit))

#define led (1 << PB0)
#define led_port PORTB
#define led_direction DDRB

int main( void )
{
   output( led_direction, led );

   while( 1 )
   {
      set( led_port, led );
      _delay_ms( 500 );
      clear( led_port, led );
      _delay_ms( 500 );
   }
}

