#include "util.h"

#include <avr/io.h>
#include <util/delay.h>
#include <stdio.h>
#include <string.h>

#include "hd44780.h"


#define LED_PIN 8
#define LED_OUT PORTC
#define LED_DDR DDRC


uint16_t readADC( uint8_t chnl )
{
   chnl &= 0x07;
   ADMUX = chnl;
   ADCSRA = ( 1 << ADEN ) | ( 1 << ADSC ) | 0x07;
   while( !( ADCSRA & ( 1 << ADIF ) ) );
   uint16_t adc = ADC;
   ADCSRA |= 1 << ADIF;
   
   return( adc );
   
}

/*
void writeLCD( const char txt[] )
{
   for( int i = 0; i < strlen( txt ); i++ )
   {
      lcd_write_ram( txt[i] );
   }
}
*/
int main( void )
{
   lcd_init();
   lcd_ctrl_display_cursor( 1, 0, 0 );
   lcd_set_entry_mode( 1, 0 );
   lcd_clear_display();
   lcd_return_home();

/*   lcd_set_ddram_address( 0 );
   writeLCD( "Hello, world!" );
   lcd_set_ddram_address( 64 );
   writeLCD( "Line 2" );
   lcd_set_ddram_address( 20 );
   writeLCD( "Line 3" );
   lcd_set_ddram_address( 84 );
   writeLCD( "Line 4" );
   
   while(1);*/

   output( LED_DDR, LED_PIN );
   
   const char txt[] = "                Can anyone read this?! Hello, world! Test 1 2 3 does this work? Cool!";
   char tmp[32];

   for( int j = 0; 1; j++ )
   {
      lcd_return_home();

      for( int i = 0; i < 20; i++ )
      {
         lcd_write_ram( (uint8_t)txt[( i + j ) % strlen( txt )] );
      }

      // Line 2
      lcd_set_ddram_address( 64 );      
      uint16_t adcVal = readADC( 0 ); // 0..1023
      sprintf( tmp, "Value: 0x%03x", adcVal );
      for( int i = 0; i < strlen( tmp ); i++ )
      {
         lcd_write_ram( (uint8_t)tmp[i] );
      }
      
      // Line 3
      lcd_set_ddram_address( 20 );
      int ctr = ( adcVal * 20 ) / 1023;
      for( int i = 0; i < ctr; i++ )
      {
         lcd_write_ram( '#' );
      }
      for( int i = 0; i < 20 - ctr; i++ )
      {
         lcd_write_ram( ' ' );
      }
      
      // Line 4
      lcd_set_ddram_address( 84 );
      const char emptyLine[] = " Unused line 4 ;-) ";
      for( int i = 0; i < strlen( emptyLine ); i++ )
      {
         lcd_write_ram( emptyLine[i] );
      }

      if( j & 1 )
      {
         setPins( LED_OUT, LED_PIN );
      } else
      {
         clearPins( LED_OUT, LED_PIN );
      }
      
      _delay_ms( 125 );
   }
}

